<?php


namespace Cms\Model\Geodata;

use Cms\Model\GpsLocationPointModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;
use POM\PredefinedType\GpsLocationPoint;

/**
 * Class AdminModel
 * @package Cms\Model\Geodata
 * @property int $id
 * @property int $parent_id
 * @property int $level
 * @property string $code_parent
 * @property string $country_alpha2
 * @property string $code_concat
 * @property string $code_simple
 * @property string $name
 * @property string $name_locale
 * @property string $name_slug
 * @property string $name_uppercase
 * @property string $geonames_id
 * @property string $osm_id
 * @property int $delegue_id
 * @property string $border_geojson
 * @property string $carte_guide
 * @property \POM\PredefinedType\GpsLocationPoint $border_center
 */
class AdminModel extends DomainObjectAbstract
{
    use GpsLocationPointModelTrait {
        propertySet as gpsOffsetSet;
    }
    use StampAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $parent_id;

    /** @var  int */
    protected $level;

    /** @var  string */
    protected $code_parent;

    /** @var  string */
    protected $country_alpha2;

    /** @var  string */
    protected $code_concat;

    /** @var  string */
    protected $code_simple;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $name_locale;

    /** @var  string */
    protected $name_slug;

    /** @var  string */
    protected $name_uppercase;

    /** @var  int */
    protected $geonames_id;

    /** @var  string */
    protected $osm_id;

    /** @var  int */
    protected $delegue_id;

    /** @var  string */
    protected $border_geojson;

    /** @var  \POM\PredefinedType\GpsLocationPoint */
    protected $border_center;

    /** @var  string */
    protected $carte_guide;

    /**
     * @inheritdoc
     */
    public function propertyGet($name)
    {
        $result = parent::propertyGet($name);
        if ($result instanceof GpsLocationPoint
            && (!$result->latitude || !$result->longitude)) {
            $result = null;
        }
        return $result;
    }

    /**
     * @inheritdoc
     */
    public function propertySet($offset, $value)
    {
        if ($offset === 'border_center') {
            if (is_scalar($value)) {
                $value = trim($value);
            }
            if (\is_array($value) && isset($value['latitude'], $value['longitude'])) {
                $value = (new GpsLocationPoint())->populate([
                    'latitude' => str_replace(',', '.', $value['latitude']),
                    'longitude' => str_replace(',', '.', $value['longitude']),
                ], true);
            }
            if ($value instanceof GpsLocationPoint) {
                parent::propertySet($offset, $value);
            } elseif (!empty($value)) {
                $this->gpsOffsetSet($offset, $value);
            } else {
                parent::propertySet($offset, null);
            }
        } else {
            parent::propertySet($offset, $value);
        }
    }
}
