<?php


namespace Cms\Search;

use Cms\Cache\CacheHelperTrait;
use Move\Cache\CacheAwareInterface;
use Psr\Cache\CacheItemPoolInterface;

/**
 * Class AbstractSearchService
 * @package CampingCar\Search
 */
abstract class AbstractSearchService implements
    CacheAwareInterface,
    SearchClientAdapterAwareInterface
{
    use CacheHelperTrait;
    use SearchClientAdapterAwareTrait;

    /** @var int */
    public static $BY_PAGE_RESULTS = 20;

    /**
     * SearchHelper constructor.
     * @param \Cms\Search\SearchClientAdapterInterface $clientAdapter
     * @param \Psr\Cache\CacheItemPoolInterface $cacheItemPool
     */
    public function __construct(
        SearchClientAdapterInterface $clientAdapter,
        CacheItemPoolInterface $cacheItemPool
    ) {
        $this->setSearchClient($clientAdapter);
        $this->setItemCachePool($cacheItemPool);
    }


    /**
     * @param string|array|\Cms\Search\ElasticQueryBuilderInterface $query
     * @return int
     */
    public function getTotalSearchHits($query) : int
    {
        return (int)$this->getLimitSearchResults($query)->getTotalHits();
    }

    /**
     * @param string|array|\Cms\Search\ElasticQueryBuilderInterface $query
     * @param int|null $totalHits
     * @return \Cms\Search\ResultElementInterface[]|\Cms\Search\ResultSetInterface
     */
    public function getAllSearchResults($query, int &$totalHits = null)
    {
        $totalHits = $this->getTotalSearchHits($query);
        return $this->getLimitSearchResults($query, $totalHits);
    }

    /**
     * @param string|array|\Cms\Search\ElasticQueryBuilderInterface $query
     * @param int $limit
     * @return \Cms\Search\ResultElementInterface[]|\Cms\Search\ResultSetInterface
     */
    abstract public function getLimitSearchResults($query, int $limit = 0);
}
