<?php

namespace Cms\Serializer;

use Cms\DashParser\Serializer\HtmlEntityLinkConverter;
use Cms\DashParser\Serializer\HtmlEntityResourceConverter;
use Move\Embed\EmbedMapper;

/**
 * Class AmpEntityConverter
 * @package Cms\Serializer
 */
class AmpEntityConverter extends HtmlEntityConverter
{

    /**
     * HtmlEntityConverter constructor.
     * @param EmbedMapper $embedMapper
     * @param AmpEntityImageConverter|null $imageConverter
     * @param AmpEntityEmbedConverter|null $embedConverter
     * @param \Cms\DashParser\Serializer\HtmlEntityLinkConverter|null $linkConverter
     * @param \Cms\DashParser\Serializer\HtmlEntityResourceConverter|null $resourceConverter
     */
    public function __construct(
        EmbedMapper $embedMapper,
        AmpEntityImageConverter $imageConverter = null,
        AmpEntityEmbedConverter $embedConverter = null,
        HtmlEntityLinkConverter $linkConverter = null,
        HtmlEntityResourceConverter $resourceConverter = null
    ) {
        parent::__construct(
            $embedMapper,
            $imageConverter ?: new AmpEntityImageConverter(),
            $embedConverter ?: new AmpEntityEmbedConverter($embedMapper),
            $linkConverter,
            $resourceConverter
        );
    }
}
