<?php

namespace Cms\Serializer;

use Cms\DashParser\Entity\EntityEmbed;
use Cms\DashParser\Entity\EntityInterface;

/**
 * Class AmpEntityEmbedConverter
 * @package Cms\Serializer
 */
class AmpEntityEmbedConverter extends HtmlEntityEmbedConverter
{

    /**
     * @param \DOMDocument $doc
     * @param EntityInterface $entity
     * @param null $nodeText
     * @return \DOMElement|null
     */
    public function getEntityNode(\DOMDocument $doc, EntityInterface $entity, $nodeText = null)
    {
        if (!$entity instanceof EntityEmbed) {
            return null;
        }

        $embedUrl = $entity->getUrl();
        try {
            $embedModel = $this->embedMapper->fetchModel($embedUrl);
            if (!empty($embedModel)) {
                preg_match('/src="([^"]+)"/', $embedModel->html, $match);

                // on vide le contenu
                $iframeNode = $doc->createElement('amp-iframe');
                $iframeNode->setAttribute('src', $match[1] ?: $embedModel->source_url);
                $iframeNode->setAttribute('height', $embedModel->thumbnail_height);
                $iframeNode->setAttribute('width', $embedModel->thumbnail_width);
                $iframeNode->setAttribute('frameborder', '0');
                $iframeNode->setAttribute('allowfullscreen', '');
                $iframeNode->setAttribute('layout', 'responsive');
                $iframeNode->setAttribute('sandbox', 'allow-scripts allow-same-origin allow-popups');
                return $iframeNode;
            }
        } catch (\Exception $e) {
            trigger_error('Error while getting embed model : ' . $e, E_USER_WARNING);
        }
        return null;
    }
}
