<?php

namespace Move\Http\Strategy\Handler;

use Move\Http\RequestUtils;
use Move\Http\Strategy\DataContainer\EngineDataContainer;
use Move\Http\Strategy\ExceptionHandler\ExceptionHandlerInterface;
use Move\Http\Strategy\ResponseFactory;
use Move\Http\Strategy\Serializer\SerializerInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Class RssHandlerService
 * @package src\Move\Http\Strategy\Handler
 */
class RssHandlerService extends HandlerServiceAbstract implements HandlerServiceInterface
{

    /**
     * @var string
     */
    protected $tpl;

    /**
     * RssHandlerService constructor.
     * @param SerializerInterface $serializer
     * @param string $tpl
     * @param ExceptionHandlerInterface $exceptionHandler
     */
    public function __construct(
        SerializerInterface $serializer,
        $tpl,
        ExceptionHandlerInterface $exceptionHandler = null
    ) {
        parent::__construct($serializer, $exceptionHandler);
        $this->tpl = $tpl;
    }

    /**
     * @inheritdoc
     */
    public function isSatisfiedBy($request) : bool
    {
        if (!$request instanceof ServerRequestInterface) {
            return false;
        }

        // check du type
        $mime = 'application/rss+xml';
        $pathMatch = preg_match('@rss.xml$@', $request->getUri()->getPath());
        return (RequestUtils::isAcceptable($request, $mime) && $pathMatch) || $pathMatch;
    }

    /**
     * @inheritdoc
     * @throws \InvalidArgumentException
     */
    public function determineResponse($dataset, ResponseInterface $response)
    {
        if (!$dataset instanceof ResponseFactory) {
            $dataset = new ResponseFactory($dataset);
        }
        // on récupère le dataset de la response
        $getDataset = $dataset->getDataset();
        // si on n'a pas de template, on prend celui par défaut
        if (!$getDataset instanceof EngineDataContainer) {
            $getDataset = new EngineDataContainer($this->tpl, $getDataset->getDataset());
            $dataset->setDataset($getDataset);
        }
        $response = $dataset->determineResponse($this->getSerializer(), $response);
        // ajout le header xml a la reponse
        return $response->withHeader('Content-Type', 'application/rss+xml');
    }
}
