<?php

namespace Move\Http\Strategy\ExceptionHandler;

use League\Route\Http\Exception\BadRequestException;
use League\Route\Http\Exception\ConflictException;
use Move\Http\Strategy\ResponseFactory;
use PHPUnit\Framework\TestCase;

/**
 * Class ExceptionHandlerTest
 * @package Move\Http\Strategy\ExceptionHandler
 */
class ExceptionHandlerTest extends TestCase
{

    /**
     * @return array
     */
    public function convertPdoExceptionDataProvider()
    {
        return [
            [1062, ConflictException::class],
            [1452, BadRequestException::class],
            [1000, \PDOException::class],
        ];
    }

    /**
     * @covers ExceptionHandler::__construct
     */
    public function testConstruct()
    {
        $handler = new ExceptionHandler();
        $this->assertInstanceOf(ExceptionHandler::class, $handler);
    }

    /**
     * @covers ExceptionHandler::handle
     * @depends testConstruct
     */
    public function testHandle()
    {
        $message = 'this is a test';
        $handler = new ExceptionHandler(true);
        $result = $handler->handle(new \Exception($message));
        $this->assertInstanceOf(ResponseFactory::class, $result);
    }

    /**
     * @depends testConstruct
     * @dataProvider convertPdoExceptionDataProvider
     * @covers ExceptionHandler::convertPDOException
     * @param int $code
     * @param string $expectedClass
     */
    public function testConvertPDOException($code, $expectedClass)
    {
        $message = 'Message';
        $handler = new ExceptionHandler(true);
        $exception = new \PDOException('Message');

        $exception->errorInfo = [
            1 => $code,
            2 => $message
        ];

        $converted = $handler->convertPDOException($exception);

        $this->assertInstanceOf($expectedClass, $converted);

    }

}
