<?php
/**
 * Created by PhpStorm.
 * User: MOVE-02
 * Date: 11/28/2017
 * Time: 11:20 AM
 */

namespace Move\Image;

use PHPUnit\Framework\TestCase;

/**
 * Class IptcTest
 * @package Move\Image
 */
class IptcTest extends TestCase
{
    /** @var string image path */
    protected $path = __DIR__ .'/file/picture.jpg';

    /** @var string image path */
    protected $pathNoIptc = __DIR__ .'/file/picture-no-iptc.jpg';

    protected $properties = [
        'title' => 'string',
        'country' => 'array',
        'copyright' => 'string',
        'caption' => 'string',
        'headline' => 'string',
        'credit' => 'string',
        'source' => 'string',
        'jobtitle' => 'string',
        'city' => 'string',
        'state' => 'string',
        'country' => 'string'
    ];
    /**
     * @covers Iptc::createFromInfo
     */
    public function testCreateFromInfo()
    {
        getimagesize($this->path, $info);
        $instance = Iptc::createFromInfo($info);
        $this->assertInstanceOf(Iptc::class, $instance);
        return $instance;
    }

    /**
     * @covers Iptc::createFromInfo
     * @expectedException \InvalidArgumentException
     */
    public function testCreateFromInfoThrowsException()
    {
        getimagesize($this->pathNoIptc, $info);
        Iptc::createFromInfo($info);
    }

    /**
     * @covers Iptc::createFromString
     */
    public function testCreateFromString()
    {
        getimagesize($this->path, $info);
        $string = $info['APP13'];

        $instance = Iptc::createFromString($string);
        $this->assertInstanceOf(Iptc::class, $instance);
    }

    /**
     * @covers Iptc::createFromArray
     */
    public function testCreateFromArray()
    {
        getimagesize($this->path, $info);
        $array = iptcparse($info['APP13']);

        $instance = Iptc::createFromArray($array);
        $this->assertInstanceOf(Iptc::class, $instance);
    }

    /**
     * @depends testCreateFromInfo
     * @covers Iptc::__get
     * @param Iptc $iptc
     */
    public function testGet(Iptc $iptc)
    {
        foreach ($this->properties as $property => $type) {
            $this->assertInternalType(
                $type,
                $iptc->$property,
                "Property [$property] must be a [$type]"
            );
            $this->assertNotEmpty($iptc->$property);
        }
    }

    /**
     * @depends testCreateFromInfo
     * @covers Iptc::__set
     * @param Iptc $iptc
     * @expectedException \InvalidArgumentException
     */
    public function testSet(Iptc $iptc)
    {
        $iptc->title = 'new title';
    }

    /**
     * @depends testCreateFromInfo
     * @covers Iptc::__get
     * @param Iptc $iptc
     */
    public function testIsSet(Iptc $iptc)
    {
        foreach ($this->properties as $property => $type) {
            $this->assertTrue(isset($iptc->$property), "The property [$property] does not exists");
        }

        $this->assertFalse(isset($iptc->notExistingProperty));
    }

    /**
     * @depends testCreateFromInfo
     * @covers Iptc::GetArrayCopy
     * @param Iptc $iptc
     */
    public function testGetArrayCopy(Iptc $iptc)
    {
        $array = $iptc->getArrayCopy();

        $this->assertNotEmpty($array);
        foreach ($this->properties as $k => $val) {
            $this->assertArrayHasKey($k, $array);
        }
    }
}
