<?php

namespace Cms\Bundle\Member\Exception;

use Cms\Bundle\Member\MemberErrorCode;

/**
 * Class ApiFailedException
 * @package Cms\Bundle\Member\Exception
 */
class ApiFailedException extends RuntimeException
{

    /**
     * ApiFailedException constructor.
     * @param string|null $message
     * @param \Throwable|null $previous
     * @param mixed|null $code
     */
    public function __construct(string $message = null, \Throwable $previous = null, $code = null)
    {
        parent::__construct($message, $code ?: MemberErrorCode::API_FAILED, $previous);
    }
}
