<?php

namespace Cms\Model\Campsite\Group;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class GroupModel
 * @package Cms\Model\Campsite\Group
 * @property int $id
 * @property string $name
 * @property string $slug
 * @property GroupType $type
 */
class GroupModel extends DomainObjectAbstract
{
    use StampAwareModelTrait;
    use CmsUserIdAwareTrait;
    use ScopeAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var string */
    protected $name;

    /** @var string */
    protected $slug;

    /** @var GroupType */
    protected $type;
}
