<?php


namespace Move\Advertiser\Google\DfpSmallBusiness;

/**
 * Class SlotFactory
 * @package Move\Advertiser\Google\DfpSmallBusiness
 */
class SlotFactory
{
    /**
     * @param string|null $divId
     * @return \Move\Advertiser\Google\DfpSmallBusiness\Slot
     */
    public static function defineOutOfPageSlot(string $divId = null) : Slot
    {
        $slot = new Slot($divId);
        return $slot;
    }

    /**
     * @param \Move\Advertiser\Google\DfpSmallBusiness\Size[]|array $sizes
     * @param string|null $divId
     * @return \Move\Advertiser\Google\DfpSmallBusiness\Slot
     */
    public static function defineSlot(array $sizes, string $divId = null) : Slot
    {
        foreach ($sizes as &$size) {
            if (!$size instanceof Size) {
                if (\is_array($size) && count($size) === 2) {
                    $size = new Size($size[0], $size[1]);
                } elseif (\is_string($size) && $size === 'fluid') {
                    $size = new SizeFluid($size);
                } else {
                    $size = null;
                }
            }
        }
        unset($size);

        $slot = new Slot($divId, array_filter($sizes));
        return $slot;
    }
}
