<?php

namespace Move\Http;

use League\Container\ServiceProvider\AbstractServiceProvider;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response;
use Zend\Diactoros\ServerRequestFactory;

/**
 * Class DiactorosProvider
 * @package Move\Http
 */
class DiactorosProvider extends AbstractServiceProvider
{

    /**
     * @var array
     */
    protected $provides = [
        ServerRequestInterface::class,
        ResponseInterface::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        $container = $this->getContainer();

        $request = ServerRequestFactory::fromGlobals();

        $container->share(ServerRequestInterface::class, $request);

        $container->add(ResponseInterface::class, Response::class);
    }
}
