<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Parser\ParserInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class VimeoTest
 * @package Embed\AdapterProvider
 */
class VimeoTest extends TestCase
{
    /**
     * @return array
     */
    public function provideStrings()
    {
        $instance = new Vimeo();
        $parser = $instance->getParser();

        return [
            [$parser, 'https://www.vimeo.com/groups/12456/videos/', true, ''],
            [$parser, 'https://www.vimeo.com/groups/12456/videos/abc1', true, 'abc1'],
            [$parser, 'http://www.vimeo.com/groups/12456/videos/abc2', true, 'abc2'],
            [$parser, 'www.vimeo.com/groups/12456/videos/abc3', true, 'abc3'],
            [$parser, 'vimeo.com/groups/12456/videos/abc4', true, 'abc4'],

            [$parser, 'https://www.vimeo.com/channels/12456/', true, ''],
            [$parser, 'https://www.vimeo.com/channels/12456/abc5', true, 'abc5'],
            [$parser, 'http://www.vimeo.com/channels/12456/abc6', true, 'abc6'],
            [$parser, 'www.vimeo.com/channels/12456/abc7', true, 'abc7'],
            [$parser, 'vimeo.com/channels/12456/abc8', true, 'abc8'],
            [$parser, 'vimeo.com/channels/12456/', true, ''],

            [$parser, 'https://www.vimeo.com/', true, ''],
            [$parser, 'https://www.vimeo.com/abc9', true, 'abc9'],
            [$parser, 'http://www.vimeo.com/abc10', true, 'abc10'],
            [$parser, 'www.vimeo.com/abc11', true, 'abc11'],
            [$parser, 'vimeo.com/abc12', true, 'abc12'],
            [$parser, 'vimeo.com/', true, ''],

            [$parser, 'vimeo.com', false, ''],

        ];
    }

    /**
     * @covers Vimeo::getAdapter
     */
    public function testGetAdapter()
    {
        $instance = new Vimeo();
        $this->assertInstanceOf(
            Oembed::class,
            $instance->getAdapter()
        );
    }

    /**
     * @covers Vimeo::getParser
     */
    public function testGetParser()
    {
        $instance = new Vimeo();
        $this->assertInstanceOf(
            ParserInterface::class,
            $instance->getParser()
        );
    }

    /**
     * @dataProvider provideStrings
     * @depends testGetParser
     * @param ParserInterface $adapter
     * @param $string
     * @param $expectedResult
     * @param $expectedParam
     */
    public function testGetParserResult(ParserInterface $adapter, $string, $expectedResult, $expectedParam)
    {
        $this->assertEquals(
            $expectedResult,
            $adapter->matchString($string, $param)
        );

        if ($expectedResult) {
            $this->assertEquals($expectedParam, $param[1]);
        }
    }
}
