<?php

namespace Cms\Bundle\Member\Exception;

use Cms\Bundle\Member\MemberErrorCode;

/**
 * Class LoginNotFoundException
 * @package Cms\Bundle\Member\Exception
 */
class LoginNotFoundException extends RuntimeException
{
    /** @var string */
    private $identifier;

    /** @var int */
    private $scopeId;

    /**
     * MemberNotFoundException constructor.
     * @param string $identifier
     * @param int $scopeId
     * @param \Throwable|null $previous
     */
    public function __construct(string $identifier, int $scopeId, \Throwable $previous = null)
    {
        $message = 'login not found with identifier : ' . $identifier . ' in scope ' . $scopeId;
        parent::__construct($message, MemberErrorCode::LOGIN_NOT_FOUND, $previous);
        $this->identifier = $identifier;
        $this->scopeId = $scopeId;
    }

    /**
     * @return string
     */
    public function getIdentifier() : string
    {
        return $this->identifier;
    }

    /**
     * @return int
     */
    public function getScopeId() : int
    {
        return $this->scopeId;
    }
}
