<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Scheduler\SchedulerTaskClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class SchedulerProvider
 * @package Cms\Client\Service
 */
class SchedulerProvider extends AbstractServiceProvider
{
    /** @var array */
    protected $provides = [
        SchedulerTaskClient::class,
        SchedulerService::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        //add client
        $this->container->add(SchedulerTaskClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        //add service
        $this->container->add(SchedulerService::class)
            ->withArguments([
                SchedulerTaskClient::class,
            ]);
    }
}
