<?php


namespace Cms\Model\AddressBook\Trip;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\GpsLocationPointModelTrait;
use Cms\Model\ScopeAwareModelTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;
use POM\PredefinedType\GpsLocationPoint;

/**
 * Class TripModel
 * @package Cms\Model\AddressBook\Trip
 * @property int $id
 * @property int $category_id
 * @property string $name
 * @property int $author_id
 * @property string $author_signature
 * @property string $slug
 * @property string $encoded_polyline
 * @property string $description
 * @property \POM\PredefinedType\GpsLocationPoint $center_location
 * @property string $elevation
 * @property string $distance
 * @property TripType $type
 * @property TripState $state
 * @property TripVisibility $visibility
 */
class TripModel extends DomainObjectAbstract
{
    use ScopeAwareModelTrait;
    use CmsUserIdAwareTrait;
    use StampAwareModelTrait;
    use GpsLocationPointModelTrait {
        propertySet as gpsOffsetSet;
    }

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $category_id;

    /** @var  string */
    protected $name;

    /** @var  int */
    protected $author_id;

    /** @var  string */
    protected $author_signature;

    /** @var  string */
    protected $slug;

    /** @var  string */
    protected $encoded_polyline;

    /** @var  string */
    protected $description;

    /** @var  \POM\PredefinedType\GpsLocationPoint */
    protected $center_location;

    /** @var  string */
    protected $elevation;

    /** @var  string */
    protected $distance;

    /** @var  TripVisibility */
    protected $visibility;

    /** @var  TripType */
    protected $type;

    /** @var  TripState */
    protected $state;

    /**
     * @inheritdoc
     */
    public function propertyGet($name)
    {
        $result = parent::propertyGet($name);
        if ($result instanceof GpsLocationPoint
            && (!$result->latitude || !$result->longitude)) {
            $result = null;
        }
        return $result;
    }

    /**
     * @param string $offset
     * @param mixed $value
     */
    public function propertySet($offset, $value)
    {
        // modification pour nombre decimal
        if ($offset === 'center_location') {
            if (is_scalar($value)) {
                $value = trim($value);
            }
            if (\is_array($value) && isset($value['latitude'], $value['longitude'])) {
                $value = (new GpsLocationPoint())->populate([
                    'latitude' => str_replace(',', '.', $value['latitude']),
                    'longitude' => str_replace(',', '.', $value['longitude']),
                ], true);
            }
            if ($value instanceof GpsLocationPoint) {
                parent::propertySet($offset, $value);
            } elseif (!empty($value)) {
                $this->gpsOffsetSet($offset, $value);
            } else {
                parent::propertySet($offset, null);
            }
        } else {
            if ($offset === 'distance' && !empty($value) && \is_float($value)) {
                $value = number_format($value, 2, '.', '');
            }
            parent::propertySet($offset, $value);
        }
    }
}
