<?php

namespace Cms\Plugin\Article;

use Cms\Model\AbstractConfigModel;
use Cms\Model\Article\Plugin\PluginType;

/**
 * Class PluginConfigFactory
 * @package Cms\Plugin\Article
 */
class PluginConfigFactory
{

    /**
     * @param PluginType|string $pluginType
     * @param array $dataset
     * @return PluginPlusMoinsConfig|PluginMatchConfig|AbstractConfigModel|null
     */
    public static function createFromPluginType($pluginType, array $dataset = [])
    {
        if (!$pluginType instanceof PluginType
            && !PluginType::isValid($pluginType)
        ) {
            throw new \InvalidArgumentException('type unknown');
        }
        switch ($pluginType) {
            case PluginType::PLUS_MOINS:
                return (new PluginPlusMoinsConfig())->populate($dataset, true);
                break;
            case PluginType::MATCH:
                return (new PluginMatchConfig())->populate($dataset, true);
                break;
            case PluginType::NOTE_REDAC:
                return (new PluginNoteRedacConfig())->populate($dataset, true);
                break;
            default:
                return null;
                break;
        }
    }
}
