<?php

namespace Move\Filter\Validator;

use UnexpectedValueException;

/**
 * Class StateValidatorException
 * @package Move\Filter\Validator
 */
class StateValidatorException extends UnexpectedValueException
{

    /**
     * @var string
     */
    private $propName;

    /**
     * StateValidatorException constructor.
     * @param string $propName
     * @param int $code
     * @param \Exception $previous
     */
    public function __construct($propName, $code = null, \Exception $previous = null)
    {
        $message = sprintf('Unexpected value on property %s', $propName);
        parent::__construct($message, $code, $previous);
        $this->propName = $propName;
    }

    /**
     * @return string
     */
    public function getPropName()
    {
        return $this->propName;
    }
}
