<?php


namespace Move\Newsletter\Provider;

/**
 * Interface ProviderAdapterInterface
 * @package Move\Newsletter\Provider
 */
interface ProviderInterface
{

    /**
     * @param string $email
     * @param array $dataset
     * @return bool
     */
    public function update(string $email, array $dataset = []) : bool;

    /**
     * @param string $email
     * @param array $dataset
     * @return bool
     */
    public function insert(string $email, array $dataset = []) : bool;

    /**
     * @param string $email
     * @return bool
     */
    public function delete(string $email) : bool;

    /**
     * @param string $email
     * @return bool
     */
    public function blacklist(string $email) : bool;

    /**
     * @param string $email
     * @return bool
     */
    public function unblacklist(string $email) : bool;
}
