<?php

namespace Move\Template\Html\Meta;

/**
 * Class Property
 * @package Html\Metadata
 */
class Property implements MetaInterface
{
    /** @var string */
    protected $name;

    /** @var string */
    protected $value;

    /** @var bool */
    protected $isUnique;

    /**
     * Meta property/content
     * @param string $name
     * @param string $value
     * @param bool $isUnique
     */
    public function __construct($name, $value, $isUnique = true)
    {
        $this->name = strtolower($name);
        $this->value = $value;
        $this->isUnique = $isUnique;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->render();
    }

    /**
     * Retourne un identifiant
     */
    public function ident() : string
    {
        if (!$this->isUnique) {
            return uniqid($this->name, true);
        }
        return $this->name;
    }

    /**
     * @{@inheritdoc}
     */
    public function render() : string
    {
        if (empty($this->value) || empty($this->name)) {
            return '';
        }
        $source = '<meta property="' . $this->name . '" content="' .
            htmlentities($this->value, ENT_COMPAT, 'UTF-8', false) . '">';
        return $source;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy() : array
    {
        return [
            'property' => $this->name,
            'value' => $this->value,
            'uniq' => $this->isUnique,
        ];
    }
}
