<?php

namespace Move\Advertiser\Google\DfpSmallBusiness;

use PHPUnit\Framework\TestCase;

/***
 * Class SizeTest
 * @package Move\Advertiser\Google\DfpSmallBusiness
 */
class SizeTest extends TestCase
{

    /**
     * @return \Move\Advertiser\Google\DfpSmallBusiness\Size
     */
    public function testConstruct()
    {
        $size = new Size(100, 50);
        $this->assertSame(100, $size->width);
        $this->assertSame(50, $size->height);
        return $size;
    }

    /**
     *
     */
    public function testEmptyConstruct()
    {
        $size = new Size();
        $this->assertSame(0, $size->width);
        $this->assertSame(0, $size->height);
    }

    /**
     * @depends testConstruct
     * @param \Move\Advertiser\Google\DfpSmallBusiness\Size $size
     */
    public function testJsonEncode(Size $size)
    {
        $this->assertJsonStringEqualsJsonString(
            json_encode($size),
            json_encode([$size->width, $size->height])
        );
    }
}
