<?php

namespace Move\Embed\Adapter;

use Move\Embed\EmbedModel;
use Move\Embed\Normalizer\DigitekaNormalizer;
use Move\Embed\Parser\ParserInterface;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class DigitekaTest
 * @package Move\Embed\Adapter
 */
class DigitekaTest extends TestCase
{
    /**
     * @param $className
     * @param array $methodsReturns
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    protected function createCustomMock($className, array $methodsReturns){
        $mock = $this
            ->getMockBuilder($className)
            ->setMethods(array_keys($methodsReturns))
            ->getMock();

        foreach ($methodsReturns as $method => $values) {
            $mock
                ->expects($this->any())
                ->method($method)
                ->willReturn($values);
        }
        return $mock;
    }

    /**
     * @covers Digiteka::_construct
     */
    public function testConstruct()
    {
        /** @var ParserInterface|\PHPUnit_Framework_MockObject_MockObject $parser */
        $parser = $this
            ->getMockBuilder(ParserInterface::class)
            ->setConstructorArgs([''])
            ->getMock();

        /** @var DigitekaNormalizer|\PHPUnit_Framework_MockObject_MockObject $normalizer */
        $normalizer = $this
            ->getMockBuilder(DigitekaNormalizer::class)
            ->setConstructorArgs([$parser, ''])
            ->getMock();

        $instance = new Digiteka($normalizer);
        $this->assertInstanceOf(Digiteka::class, $instance);

        return $instance;
    }

    /**
     * @covers Digiteka::getEmbedModel
     * @depends testConstruct
     */
    public function testGetEmbedModelReturnNull()
    {
        /** @var Digiteka $digiteka */
        $digiteka = $this->createCustomMock(Digiteka::class, []);

        $embed = $digiteka->getEmbedModel('default/index', []);
        $this->assertNull($embed);
    }

    /**
     * @covers Digiteka::getEmbedModel
     * @depends testConstruct
     */
    public function testGetEmbedModel()
    {
        /** @var Digiteka $digiteka */
        $digiteka = $this->createCustomMock(
            Digiteka::class,
            [
                'call' => [
                    'results' => [
                        'iframe' => 'iframe url',
                        'image' => 'http://imageurl',
                        'title' => 'my title'
                    ]
                ]
            ]
        );

        $embed = $digiteka->getEmbedModel('default/index', []);
        $this->assertInstanceOf(EmbedModel::class, $embed);

        $this->assertNotEmpty(Reflection::getValue($embed, 'html'));
        $this->assertNotEmpty(Reflection::getValue($embed, 'source_url'));
    }

}
