<?php

namespace Move\Jato\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class FetchAllSelectionModelCommandTest
 * @package Move\Jato\Command
 */
class FetchAllSelectionModelCommandTest extends TestCase
{
    /**
     * @return FetchAllSelectionModelCommand
     */
    public function testConstruct() : FetchAllSelectionModelCommand
    {
        $database = 'SSCF_CS2002';
        $makes = ['test', 'makeTest'];
        $filters = ['filter', 'filterTest'];
        $command = new FetchAllSelectionModelCommand($database, $makes, $filters);

        $databaseTest = $command->getDatabase();
        $filtersTest = $command->getFilters();
        $makesTest = $command->getMakes();

        $this->assertEquals($database, $databaseTest, 'Database not equal');
        $this->assertEquals($filters, $filtersTest, 'Filters not equal');
        $this->assertEquals($makes, $makesTest, 'Makes not equal');

        return $command;
    }

    /**
     * @depends testConstruct
     * @param FetchAllSelectionModelCommand $command
     */
    public function testGetFilters(FetchAllSelectionModelCommand $command)
    {
        $result = $command->getFilters();
        $this->assertInternalType('array', $result, 'Not an array');
        $this->assertNotEmpty($result, 'Filters empty');
    }

    /**
     * @depends testConstruct
     * @param FetchAllSelectionModelCommand $command
     */
    public function testGetMakes(FetchAllSelectionModelCommand $command)
    {
        $result = $command->getMakes();
        $this->assertInternalType('array', $result, 'Not an array');
        $this->assertNotEmpty($result, 'Makes empty');
    }

    /**
     * @depends testConstruct
     * @param FetchAllSelectionModelCommand $command
     */
    public function testSetFilters(FetchAllSelectionModelCommand $command)
    {
        $newFilters = ['new', 'newFilter'];
        $command->setFilters($newFilters);
        $result = $command->getFilters();

        $this->assertEquals($newFilters, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param FetchAllSelectionModelCommand $command
     */
    public function testSetMakes(FetchAllSelectionModelCommand $command)
    {
        $newMakes = ['new', 'newMake'];
        $command->setMakes($newMakes);
        $result = $command->getMakes();

        $this->assertEquals($newMakes, $result, 'Not set');
    }

}