<?php


namespace Cms\Client\AddressBook;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\AddressBook\Trip\TripCategoryModel;

/**
 * Class AddressBookTripCategoryClient
 * @package Cms\Client\AddressBook
 */
class AddressBookTripCategoryClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'addressbook/trip/category';

    /**
     * @return AddressBookTripCategoryClientQueryBuilder
     */
    public function getBuilder()
    {
        $builder = new AddressBookTripCategoryClientQueryBuilder($this);
        return $builder;
    }

    /**
     * @param array $dataset
     * @return TripCategoryModel
     */
    public function handleData($dataset = [])
    {
        return (new TripCategoryModel())->populate($dataset ?: [], true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|TripCategoryModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
