<?php


namespace Cms\Client\Geodata;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Geodata\Model\CityRestfulModel;
use Cms\Client\Geodata\Model\PoiRestfulModel;
use GuzzleHttp\Psr7\Request;

class PoiClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'geodata/poi';

    /**
     * @param array $dataset
     * @return PoiRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new PoiRestfulModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CityRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $inseeCode
     * @param string $category
     * @param array $options
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function searchCloseToByInseeCode(string $inseeCode, string $category, array $options = [])
    {
        $uri = sprintf(
            '%s/proximity/%s/%s',
            $this->basePath,
            $category,
            $inseeCode
        );
        if (!empty($options)) {
            $first = true;
            foreach ($options as $key => $value) {
                if (is_array($value)) {
                    foreach ($value as $val) {
                        $uri .= ($first ? '?' : '&') . $key . '[]=' . urlencode($val);
                        $first = false;
                    }
                } else {
                    $uri .= ($first ? '?' : '&') . $key . '=' . urlencode($value);
                    $first = false;
                }
            }
        }

        return $this->request('GET', [$uri]);
    }

    /**
     * @param string $category
     * @param string $countySimpleCode
     * @param int|null $limit
     * @return array
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function fetchByCounty(string $category, string $countySimpleCode, int $limit = null)
    {
        $uri = sprintf(
            '%s/%s/county/%s',
            $this->basePath,
            $category,
            $countySimpleCode
        );
        if (is_int($limit) && $limit > 0) {
            $uri .= '?limit=' . $limit;
        }

        return $this->request('GET', [$uri]);
    }
}
