<?php


namespace Cms\Client\Service;

use Cms\Client\AddressBook\AddressBookAddressCategoryClient;
use Cms\Client\AddressBook\AddressBookAddressClient;
use Cms\Client\AddressBook\AddressBookClient;
use Cms\Client\AddressBook\AddressBookTripCategoryClient;
use Cms\Client\AddressBook\AddressBookTripClient;
use Cms\Client\AddressBook\Transformer\AddressTransformer;
use Cms\Client\AddressBook\Transformer\TripTransformer;
use Cms\Client\CmsHttpClientInterface;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * Class AddressBookProvider
 * @package Cms\Client\Service
 */
class AddressBookProvider extends AbstractServiceProvider implements
    BootableServiceProviderInterface
{

    /** @var array */
    protected $provides = [
        AddressBookClient::class,
        AddressBookTripClient::class,
        AddressBookAddressClient::class,
        AddressBookTripCategoryClient::class,
        AddressBookAddressCategoryClient::class,
        AddressBookService::class,
        AddressTransformer::class,
        TripTransformer::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add user client
        $this->container->add(AddressBookClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(AddressBookTripClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(TripTransformer::class)
            ->withArgument(GeodataService::class);
        $this->container->add(AddressBookAddressClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(AddressTransformer::class)
            ->withArgument(GeodataService::class);
        $this->container->add(AddressBookTripCategoryClient::class)
            ->withArgument(CmsHttpClientInterface::class);
        $this->container->add(AddressBookAddressCategoryClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add service
        $this->container->add(AddressBookService::class)
            ->withArgument(AddressBookClient::class)
            ->withArgument(AddressBookTripClient::class)
            ->withArgument(TripTransformer::class)
            ->withArgument(AddressBookAddressClient::class)
            ->withArgument(AddressTransformer::class)
            ->withArgument(AddressBookTripCategoryClient::class)
            ->withArgument(AddressBookAddressCategoryClient::class);
    }

    /**
     * Method will be invoked on registration of a service provider implementing
     * this interface. Provides ability for eager loading of Service Providers.
     * @return void
     */
    public function boot()
    {
        $this->container->addServiceProvider(new GeodataProvider());
    }
}
