<?php


namespace Cms\LinkResource;

/**
 * Class AbstractLinkResourceModel
 * @package Cms\LinkResource
 */
class AbstractLinkResourceModel extends LinkResourceModel
{

    /**
     * @return string|mixed
     * @throws \UnexpectedValueException
     */
    public function getRelationProperty()
    {
        /** @noinspection ExceptionsAnnotatingAndHandlingInspection */
        $reflectClass = new \ReflectionClass($this);
        $props = $this->getEditableProperties();
        foreach ($props as $propName) {
            $reflectProp = $reflectClass->getProperty($propName);
            // parse le comment pou trouver le @relation
            if (preg_match('/@relation/', $reflectProp->getDocComment())) {
                return $propName;
            }
        }
        $diffKeys = array_diff_key(
            array_keys($this->getArrayCopy()),
            array_keys((new LinkResourceModel())->getArrayCopy())
        );
        if (empty($diffKeys) || count($diffKeys) > 1) {
            throw new \UnexpectedValueException("impossible de définir l'attribut de liaison");
        }
        return array_keys($diffKeys)[0];
    }
}
