<?php

namespace Cms\Model\Version;

use Cms\LinkResource\LinkResourceType;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class VersionValidator
 * @package Cms\Model\Version
 */
class VersionValidator extends AbstractDomainObjectStateValidator
{
    /**
     * @return Filter
     */
    protected function createFilter()
    {
        // filtre du model
        $myFilter = new Filter([
            'scope_id' => true,
            'cms_user_id' => true,
            'link_provider' => true,
            'link_ref' => true,
            'link_type' => new EnumSpecification(LinkResourceType::class),
            'state' => new EnumSpecification(VersionState::class),
        ]);
        return $myFilter;
    }
}
