<?php


namespace Move\Search\Analyzer;

use NewcomDigital\Enum\Enum;

/**
 * Class PredefinedFilterAnalyzer
 * @package Move\Search\Analyzer
 */
class PredefinedFilterAnalyzer extends Enum
{

    /** Elision pour la langue francaise */
    public const FILTER_FRENCH_ELISION = [
        'type' => 'elision',
        'articles_case' => true,
        'articles' => [
            'l',
            'm',
            't',
            'qu',
            'n',
            's',
            'j',
            'd',
            'c',
            'jusqu',
            'quoiqu',
            'lorsqu',
            'puisqu',
        ],
    ];

    /** Stop Word en francais */
    public const FILTER_FRENCH_STOP = [
        'type' => 'stop',
        'stopwords' => ['_french_'],
        'ignore_case' => true,
    ];


    public const FILTER_FRENCH_STEMMER = [
        'type' => 'stemmer',
        'name' => 'french',
    ];


    public const FILTER_MULTI_WORDS = [
        'type' => 'shingle',
        'min_shingle_size' => 2,
        'max_shingle_size' => 10,
    ];


    public const FILTER_AUTOCOMPLETE = [
        'type' => 'edgeNGram',
        'min_gram' => 3,
        'max_gram' => 20,
    ];


    public const FILTER_DELIMITER = [
        'type' => 'word_delimiter',
        'generate_word_parts' => true,
        'catenate_words' => true,
        'catenate_numbers' => true,
        'catenate_all' => true,
        'split_on_case_change' => true,
        'preserve_original' => true,
        'split_on_numerics' => true,
        'stem_english_possessive' => true,
    ];
}
