<?php

namespace Move\Jato\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class FetchAllFilterCommandTest
 * @package Move\Jato\Command
 */
class FetchAllFilterCommandTest extends TestCase
{
    /**
     * @return FetchAllFilterCommand
     */
    public function testConstruct() : FetchAllFilterCommand
    {
        $database = 'SSCF_CS2002';
        $filter = 'filter';
        $command = new FetchAllFilterCommand($database, $filter);

        $databaseTest = $command->getDatabase();
        $filterTest = $command->getFilter();

        $this->assertEquals($database, $databaseTest, 'Database not equal');
        $this->assertEquals($filter, $filterTest, 'Filter not equal');

        return $command;
    }

    /**
     * @depends testConstruct
     * @param FetchAllFilterCommand $command
     */
    public function testGetFilter(FetchAllFilterCommand $command)
    {
        $result = $command->getFilter();
        $this->assertInternalType('string', $result, 'Filter not a string');
    }

    /**
     * @depends testConstruct
     * @param FetchAllFilterCommand $command
     */
    public function testSetFilter(FetchAllFilterCommand $command)
    {
        $new = 'new';
        $command->setFilter($new);
        $result = $command->getFilter();

        $this->assertEquals($new, $result, 'Filter not set');
    }

}