<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Command\Geodata\Command\FetchAdminCommand;
use Cms\Client\Command\Geodata\Command\FetchAllAdminByFilterCommand;
use Cms\Client\Command\Geodata\Command\FetchCityCommand;
use Cms\Client\Command\Geodata\Command\FetchCountryCommand;
use Cms\Client\Command\Geodata\Command\FetchLinkedAdminCommand;
use Cms\Client\Command\Geodata\GeodataCommandHandler;
use Cms\Client\Geodata\AdminClient;
use Cms\Client\Geodata\CityClient;
use Cms\Client\Geodata\CountryClient;
use Cms\Client\Geodata\DivisionClient;
use Cms\Client\Geodata\PoiClient;
use Cms\LinkResource\LinkResourceHandler;
use League\Container\Argument\RawArgument;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Tactician\Handler\MethodNameInflector\HandleClassNameWithoutSuffixInflector;
use Move\Command\TacticianBusFactory;

/**
 * Class GeodataProvider
 * @package Cms\Client\Service
 */
class GeodataProvider extends AbstractServiceProvider
{

    /** @var array */
    protected $provides = [
        AdminClient::class,
        CityClient::class,
        CountryClient::class,
        DivisionClient::class,
        GeodataService::class,
        PoiClient::class,
    ];

    /**
     * @inheritdoc
     */
    public function register()
    {
        // add user client
        $this->container->add(AdminClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add session client
        $this->container->add(CityClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add session client
        $this->container->add(CountryClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add session client
        $this->container->add(DivisionClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add POI client
        $this->container->add(PoiClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // creation du bus de command
        $geodataBus = TacticianBusFactory::containerMap($this->container, [
            FetchAllAdminByFilterCommand::class => GeodataCommandHandler::class,
            FetchAdminCommand::class => GeodataCommandHandler::class,
            FetchCityCommand::class => GeodataCommandHandler::class,
            FetchCountryCommand::class => GeodataCommandHandler::class,
            FetchLinkedAdminCommand::class => GeodataCommandHandler::class,
        ], new HandleClassNameWithoutSuffixInflector());

        // ajout des container
        $this->container->add(GeodataCommandHandler::class)
            ->withArguments([
                AdminClient::class,
                CityClient::class,
                CountryClient::class,
                ArticleService::class,
                LinkResourceHandler::class,
            ]);

        // add service
        $this->container->add(GeodataService::class)
            ->withArgument(AdminClient::class)
            ->withArgument(CityClient::class)
            ->withArgument(CountryClient::class)
            ->withArgument(DivisionClient::class)
            ->withArgument(new RawArgument($geodataBus));
    }
}
