<?php

namespace Cms\Controller;

use CampingFrance\Middleware\LanguageDetector;
use Cms\Client\Article\Model\CategoryRestfulModel;
use Cms\Engine\EngineDecoratorAwareInterface;
use Cms\Engine\EngineDecoratorAwareTrait;
use Cms\Model\Geodata\AdminModel;
use Cms\Model\Geodata\CityModel;
use Move\Template\AssetEngineTrait;
use Move\Template\EngineAwareInterface;
use Move\Template\EngineAwareTrait;
use Move\Template\MetaEngineTrait;
use POM\DomainObjectInterface;

/**
 * Class AbstractEngineController
 * @package Cms\Controller
 */
abstract class AbstractEngineController implements
    EngineAwareInterface,
    EngineDecoratorAwareInterface
{
    use EngineDecoratorAwareTrait;
    use EngineAwareTrait;
    use MetaEngineTrait;
    use AssetEngineTrait;


    /**
     * @param \Cms\Client\Article\Model\CategoryRestfulModel $category
     * @return \Cms\Controller\AbstractEngineController
     */
    protected function decorateWithArticleCategory(CategoryRestfulModel $category)
    {
        // ajoute les plugin a l'engine
        foreach ($category->plugins ?: [] as $pluginModel) {
            $this->getEngineDecorator()->decorate($this->engine, $pluginModel);
        }
        return $this;
    }

    /**
     * @param AdminModel|null $stateModel
     * @param AdminModel|null $countyModel
     * @param CityModel|null $cityModel
     * @return array
     */
    protected function getGeoFilters(?AdminModel $stateModel, ?AdminModel $countyModel, ?CityModel $cityModel)
    {
        $geoFilters = [];
        if ($stateModel) {
            $geoFilters['state'] = $stateModel->name_slug;
            $geoFilters['region_i18n'] = $this->getI18nSlug($stateModel);
        }
        if ($countyModel) {
            $geoFilters['county'] = $countyModel->name_slug;
            $geoFilters['dpt_i18n'] = $this->getI18nSlug($countyModel);
        }
        if ($cityModel) {
            $geoFilters['city'] = $cityModel->name_slug;
            $geoFilters['city_i18n'] = $this->getI18nSlug($cityModel);
        }

        return $geoFilters;
    }

    /**
     * @param AdminModel $admin
     * @return mixed
     */
    protected function getI18nSlug(DomainObjectInterface $admin)
    {
        return array_values(array_filter($admin->i18n, function($i18n) {
            return $i18n->language === LanguageDetector::$APP_LANGUAGE;
        }))[0]->name_slug;
    }
}
