<?php


namespace Cms\Engine;

use Cms\Engine\Decorator\EngineDecoratorInterface;
use League\Plates\Engine;
use Move\Command\Chain\HandlerInterface;

/**
 * Class EngineDecorator
 * @package Cms\Engine
 */
class EngineDecorator
{

    /** @var HandlerInterface */
    private $decoratorHandler;

    /**
     * EngineDecorator constructor.
     * @param EngineDecoratorInterface $decoratorHandler
     */
    public function __construct(EngineDecoratorInterface $decoratorHandler)
    {
        $this->decoratorHandler = $decoratorHandler;
    }

    /**
     * @param Engine $engine
     * @param mixed $tool
     * @return Engine
     */
    public function decorate(Engine $engine, $tool)
    {
        $this->decoratorHandler->setEngine($engine);
        $engine = $this->decoratorHandler->handle($tool);
        return $engine;
    }
}
