<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Normalizer\DigitekaNormalizer;
use Move\Embed\Parser\RegexParser;

/**
 * Class Digiteka
 * @package Move\Embed\AdapterProvider
 */
class Digiteka extends AbstractAdapterProvider
{

    /** @var  string */
    public static $DEFAULT_MDTK;

    /** @var null|string */
    private $mdtk;

    /**
     * Digiteka constructor.
     * @param string|null $mdtk
     */
    public function __construct(string $mdtk = null)
    {
        $this->mdtk = $mdtk;
    }

    /**
     * @return \Move\Embed\Adapter\Digiteka
     * @throws \UnexpectedValueException
     * @throws \InvalidArgumentException
     */
    public function getAdapter() : \Move\Embed\Adapter\Digiteka
    {
        if (!$this->mdtk && !self::$DEFAULT_MDTK) {
            throw new \UnexpectedValueException('the digiteka mdtk must be a valid string');
        }
        return new \Move\Embed\Adapter\Digiteka(
            new DigitekaNormalizer(
                $this->getParser(),
                $this->mdtk ?: self::$DEFAULT_MDTK
            )
        );
    }

    /**
     * @return RegexParser
     */
    public function getParser() : RegexParser
    {
        $pattern = '@^(?:https?:)?//(?:www\.)?ultimedia.com/default/index/videogeneric/id/([^/|$]+).*@i';
        return new RegexParser($pattern);
    }
}
