<?php

namespace Move\Embed;

use Move\Embed\Adapter\AdapterInterface;
use Move\Embed\AdapterProvider\AdapterProviderInterface;
use Move\Utils\Reflection;
use PHPUnit\Framework\TestCase;

/**
 * Class EmbedMapperTest
 * @package Move\Embed
 */
class EmbedMapperTest extends TestCase
{
    /**
     * @covers EmbedMapper::__construct
     * $return EmbedMapper
     */
    public function testConstruct()
    {
        /** @var AdapterProviderInterface $provider */
        $provider = $this
                ->getMockBuilder(AdapterProviderInterface::class)
                ->getMock();
        $instance = new EmbedMapper($provider);

        $this->assertEquals($provider, Reflection::getValue($instance, 'provider'));
        return $instance;
    }

    /**
     * @depends testConstruct
     * @param EmbedMapper $instance
     * @expectedException  \UnexpectedValueException
     */
    public function testGetAdapterWithException(EmbedMapper $instance)
    {
        $instance->getAdapter('123456uri');
    }

    /**
     * @covers EmbedMapper::getAdapter
     */
    public function testGetAdapter()
    {
        /** @var AdapterInterface $adapter */
        $adapter = $provider = $this
            ->getMockBuilder(AdapterInterface::class)
            ->getMock();

        /** @var AdapterProviderInterface|\PHPUnit_Framework_MockObject_MockObject $command $provider */
        $provider = $this
            ->getMockBuilder(AdapterProviderInterface::class)
            ->getMock();

        $provider->expects($this->once())
            ->method('handle')
            ->willReturn($adapter);

        $instance = new EmbedMapper($provider);
        $this->assertEquals($adapter, $instance->getAdapter(''));
    }



}
