<?php

namespace Move\Newsletter;

use Move\Newsletter\Provider\ProviderInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class ProviderAwareTraitTest
 * @package Move\Newsletter
 */
class ProviderAwareTraitTest extends TestCase
{

    /**
     * @expectedException \UnexpectedValueException
     * @return ProviderAwareTrait
     */
    public function testGetProviderEmpty()
    {
        $bus = $this->getMockForTrait(ProviderAwareTrait::class);
        $this->assertNull($bus->getProvider());
        return $bus;
    }

    /**
     * @return ProviderAwareTrait
     */
    public function testSetProvider()
    {
        $cmdBus = $this->createMock(ProviderInterface::class);
        $bus = $this->getMockForTrait(ProviderAwareTrait::class);
        $this->assertEquals($bus, $bus->setProvider($cmdBus));
        return $bus;
    }

    /**
     * @depends      testSetProvider
     * @param ProviderAwareTrait $bus
     */
    public function testGetProvider($bus)
    {
        $this->assertInstanceOf(
            ProviderInterface::class,
            $bus->getProvider()
        );
    }
}
