<?php


namespace Cms\Bundle\Member;

use League\OAuth2\Client\Provider\AbstractProvider;
use League\OAuth2\Client\Provider\Facebook;
use Move\Config;

/**
 * Class AbstractFacebookProviderController
 * @package Cms\Bundle\Member
 */
abstract class AbstractFacebookProviderController extends AbstractLoginProviderController
{
    /** @var \Move\Config */
    private $config;

    /**
     * AbstractGoogleProviderController constructor.
     * @param MemberLoginService $memberLoginService
     * @param \Move\Config $config
     * @throws \InvalidArgumentException
     */
    public function __construct(MemberLoginService $memberLoginService, Config $config)
    {
        parent::__construct($memberLoginService);
        $this->config = $config;
        if (!isset(
            $this->config['oauth.facebook.clientid'],
            $this->config['oauth.facebook.secret']
        )
        ) {
            throw new \InvalidArgumentException('oauth.facebook.[clientid,secret] must be set in config');
        }
    }

    /**
     * @return \League\OAuth2\Client\Provider\AbstractProvider
     * @throws \InvalidArgumentException
     */
    protected function getProvider() : AbstractProvider
    {
        $provider = new Facebook([
            'clientId' => $this->config['oauth.facebook.clientid'],
            'clientSecret' => $this->config['oauth.facebook.secret'],
            'redirectUri' => $this->getRedirectUri(),
            'graphApiVersion' => 'v3.2',
        ]);

        return $provider;
    }

    /**
     * @return string
     */
    abstract protected function getRedirectUri() : string;
}
