<?php


namespace Cms\Search\Address;

use Cms\Search\AbstractSearchClient;

/**
 * Class AddressSearchClient
 * @package Cms\Search\Address
 */
class AddressSearchClient extends AbstractSearchClient
{

    /**
     * @var array
     */
    protected $sortCols = [
        'id',
        'category_id',
        'address_name.raw',
        'address_firm.raw',
        'created_at',
        'modified_at',
    ];

    /**
     * @return array
     */
    protected function getDefaultMatchFields() : array
    {
        return ['city_name', 'address_name', 'address_firm'];
    }

    /**
     * @return string
     */
    protected function getMappingType() : string
    {
        return AddressIndexFactory::MAPPING_NAME;
    }
}
