<?php

namespace Move\Http\Client;

use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Middleware;
use function GuzzleHttp\choose_handler;

/**
 * Class GuzzleClientFactory
 * @package Move\Http\Client
 */
class GuzzleClientFactory
{

    /**
     * @return \GuzzleHttp\Client
     */
    public static function create() : Client
    {
        $stack = new HandlerStack(choose_handler());
        $stack->push(Middleware::httpErrors(), 'http_errors');
        $stack->push(static function (callable $handler) {
            return new GuzzleRedirectMiddleware($handler);
        }, 'allow_redirects');
        $stack->push(Middleware::cookies(), 'cookies');
        $stack->push(Middleware::prepareBody(), 'prepare_body');

        $httpClient = new Client([
            'handler' => $stack,
        ]);

        return $httpClient;
    }
}
