<?php


namespace Move\Http\Strategy\DataContainer;

/**
 * Class DataContainer
 * @package Move\Http\Strategy\DataContainer
 */
class DataContainer implements \ArrayAccess, \JsonSerializable
{

    /**
     * @var mixed
     */
    private $dataset;

    /**
     * DataContainer constructor.
     * @param mixed $dataset
     */
    public function __construct($dataset = [])
    {
        $this->dataset = $dataset;
    }

    /**
     * @inheritdoc
     */
    public function offsetExists($offset)
    {
        return 'data' === $offset;
    }

    /**
     * @inheritdoc
     */
    public function offsetGet($offset)
    {
        switch ($offset) {
            case 'data':
                return $this->getDataset();
                break;
        }
        return null;
    }

    /**
     * @inheritdoc
     */
    public function offsetSet($offset, $value)
    {
        switch ($offset) {
            case 'data':
                $this->setDataset($value);
                break;
        }
    }

    /**
     * @inheritdoc
     */
    public function offsetUnset($offset)
    {
        throw new \BadMethodCallException('no unset');
    }

    /**
     * @return mixed
     */
    public function getDataset()
    {
        return $this->dataset;
    }

    /**
     * @param mixed $dataset
     */
    public function setDataset($dataset)
    {
        $this->dataset = $dataset;
    }

    /**
     * Specify data which should be serialized to JSON
     * @link http://php.net/manual/en/jsonserializable.jsonserialize.php
     * @return mixed data which can be serialized by <b>json_encode</b>,
     * which is a value of any type other than a resource.
     * @since 5.4.0
     */
    public function jsonSerialize()
    {
        return $this->getDataset();
    }
}
