<?php

namespace Cms\Client\CmsUser;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\CmsUser\Model\CmsUserRestfulModel;
use Cms\Model\CmsUser\CmsUserModel;

/**
 * Class CmsUserClient
 * @package Cms\Client\CmsUser
 */
class CmsUserClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'cms/user';

    /**
     * @param array $dataset
     * @return CmsUserRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new CmsUserRestfulModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CmsUserRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }


    /**
     * @param null|int $scope
     * @param null|string $state
     * @param int $page
     * @return \Cms\Client\CmsUser\Model\CmsUserRestfulModel[]|\Iterator
     */
    public function getIndex($scope = null, $state = null, $page = 0)
    {
        $result = $this->getBuilder()
            ->setFilter('scope', $scope)
            ->setFilter('state', $state);
        return $result->getIndex($page);
    }

    /**
     * @param int $scope
     * @param string $provider
     * @param string $type
     * @param string $ref
     * @param int $page
     * @return \Cms\Client\CmsUser\Model\CmsUserRestfulModel[]|\Iterator
     */
    public function getIndexByResource($scope, $provider, $type, $ref, $page = 0)
    {
        $result = $this->getBuilder()
            ->setFilter('scope', $scope)
            ->setFilter('link_provider', $provider)
            ->setFilter('link_type', $type)
            ->setFilter('link_ref', $ref);
        return $result->getIndex($page);
    }

    /**
     * @param int $id
     * @return \Cms\Client\CmsUser\Model\CmsUserRestfulModel|null
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getItem($id)
    {
        $user = $this->fetchItem($id);
        return $user;
    }

    /**
     * @param string $email
     * @return null|CmsUserRestfulModel
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getItemByEmail($email)
    {
        $user = $this->fetchItem(null, [
            'email' => $email,
        ]);
        return $user instanceof CmsUserRestfulModel ? $user : null;
    }

    /**
     * @param CmsUserModel $object
     * @return CmsUserModel|null
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function updateItem(CmsUserModel $object)
    {
        return $this->saveItem($object);
    }

    /**
     * @param CmsUserModel $object
     * @return bool|CmsUserModel
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function createItem(CmsUserModel $object)
    {
        return $this->saveItem($object);
    }
}
