<?php

namespace Cms\Model\Campsite\Feature;

use Cms\Model\ScopeAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class FeatureModel
 * @package Cms\Model\Campsite\Feature
 * @property string $code
 * @property string $name
 * @property string $value_type
 * @property string $description
 * @property string $help_desc
 * @property \Cms\Model\Campsite\Feature\FeatureFieldFlagSet $field_flag
 * @property string $category_code
 * @property string $code_pao
 * @property string $prefix
 */
class FeatureModel extends DomainObjectAbstract
{
    use ScopeAwareModelTrait;

    /** @var string */
    protected $code;

    /** @var string */
    protected $name;

    /** @var string */
    protected $value_type;

    /** @var string */
    protected $description;

    /** @var string */
    protected $help_desc;

    /** @var \Cms\Model\Campsite\Feature\FeatureFieldFlagSet */
    protected $field_flag;

    /** @var  string */
    protected $category_code;

    /** @var  string */
    protected $code_pao;

    /** @var string */
    protected $prefix;
}
