<?php

namespace Cms\Model\Scheduler\LinkResource;

use Cms\LinkResource\LinkResourceType;
use Move\Filter\Filter;
use Move\Filter\Validator\AbstractDomainObjectStateValidator;
use Move\Specification\EnumSpecification;

/**
 * Class LinkResourceValidator
 * @package Cms\Model\Scheduler\LinkResource
 */
class LinkResourceValidator extends AbstractDomainObjectStateValidator
{

    /**
     * @return Filter
     */
    protected function createFilter()
    {
        $filter = new Filter([
            'scheduler_task_id' => true,
            'link_type' => new EnumSpecification(LinkResourceType::class),
        ]);

        return $filter;
    }
}
