<?php

namespace Move\Command\Command;

/**
 * Interface FilterCommandInterface
 * @package Move\Command\Command
 */
interface FilterCommandInterface
{

    /**
     * @param array $filters
     * @return \Move\Command\Command\FilterCommandInterface
     */
    public function withFilters(array $filters) : FilterCommandInterface;

    /**
     * @param string $name
     * @param array|string $value
     * @return \Move\Command\Command\FilterCommandInterface
     */
    public function withFilterValue(string $name, $value) : FilterCommandInterface;

    /**
     * @return array
     */
    public function getFilters() : array;

    /**
     * @param string $name
     * @return mixed
     */
    public function getFilterValue(string $name);
}
