<?php

namespace Move\Http\Strategy\Handler;

use Move\Specification\SpecificationInterface;
use Psr\Http\Message\ResponseInterface;

/**
 * Interface HandlerServiceInterface
 * @package Move\Http\Strategy\Handler
 */
interface HandlerServiceInterface extends SpecificationInterface
{

    /**
     * @param \Exception $exception
     * @return mixed
     */
    public function handleException(\Exception $exception);

    /**
     * @param mixed $dataset
     * @param ResponseInterface $response
     * @return ResponseInterface
     */
    public function determineResponse($dataset, ResponseInterface $response);
}
