<?php

namespace Move\Log;

use Monolog\ErrorHandler;
use Monolog\Handler\HandlerInterface;
use Monolog\Logger;
use Move\Environment;
use PHPUnit\Framework\TestCase;

/**
 * Class RollbarHandlerFactoryTest
 * @package Move\Log
 */
class RollbarHandlerFactoryTest extends TestCase
{

    /**
     * @return \Monolog\Logger
     */
    public function testInit()
    {
        $env = new Environment();
        $handler = RollbarHandlerFactory::create(
            '19f067f622c0426ea9dd8d981249568f', // unit_test
            __DIR__ . '/../../../',
            $env,
            Logger::DEBUG
        );

        $this->assertInstanceOf(HandlerInterface::class, $handler, 'bad rollbar handler');

        $logger = new Logger('unit_test');
        $logger->pushHandler($handler);

        return $logger;
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testDebug($logger)
    {
        $logger->debug('debug message');
        $this->assertTrue(true);
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testInfo($logger)
    {
        $logger->info('info message');
        $this->assertTrue(true);
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testNotice($logger)
    {
        $logger->notice('notice message');
        $this->assertTrue(true);
    }

    /**
     * @depends testInit
     * @expectedException \PHPUnit\Framework\Error\Notice
     */
    public function testTriggerNotice($logger)
    {
        ErrorHandler::register($logger);
        trigger_error('notice send with trigger', E_USER_NOTICE);
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testWarning($logger)
    {
        $logger->warning('warning message');
        $this->assertTrue(true);
    }

    /**
     * @depends testInit
     * @expectedException \PHPUnit\Framework\Error\Warning
     */
    public function testTriggerWarning($logger)
    {
        ErrorHandler::register($logger);
        trigger_error('warning send with trigger', E_USER_WARNING);
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testError($logger)
    {
        $logger->error('error message');
        $this->assertTrue(true);
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testCritical($logger)
    {
        $logger->critical('critical message');
        $this->assertTrue(true);
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testAlert($logger)
    {
        $logger->alert('alert message');
        $this->assertTrue(true);
    }

    /**
     * @depends testInit
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function testEmergency($logger)
    {
        $logger->emergency('emergency message');
        $this->assertTrue(true);
    }
}
