<?php

namespace Cms\Client\Geodata;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Geodata\Model\DivisionRestfulModel;

/**
 * Class DivisionClient
 * @package Cms\Client\Geodata
 */
class DivisionClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'geodata/division';

    /**
     * @param array $dataset
     * @return DivisionRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new DivisionRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|DivisionRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $countryCode
     * @param null|string $type
     * @param null|string $adminCodeConcat
     * @param null|int $cityId
     * @param int $page
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Model\Geodata\DivisionModel[]
     */
    public function fetchAllByCountry(
        string $countryCode,
        $type = null,
        $adminCodeConcat = null,
        $cityId = null,
        $page = 0
    ) {
        return $this->getBuilder()
            ->setFilter('country_code', $countryCode)
            ->setFilter('type', $type)
            ->setFilter('admin_code', $adminCodeConcat)
            ->setFilter('city_id', $cityId)
            ->getIndex($page);
    }
}
