<?php


namespace Cms\Client\Service;

/**
 * Trait CampsiteServiceAwareTrait
 * @package Cms\Client\Service
 */
trait CampsiteServiceAwareTrait
{
    /** @var  \Cms\Client\Service\CampsiteService */
    protected $campsiteService;

    /**
     * @param \Cms\Client\Service\CampsiteService $campsiteService
     * @return $this
     */
    public function setCampsiteService(CampsiteService $campsiteService)
    {
        $this->campsiteService = $campsiteService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\CampsiteService
     * @throws \DomainException
     */
    public function getCampsiteService() : CampsiteService
    {
        if (!$this->campsiteService instanceof CampsiteService) {
            throw new \DomainException('campsiteService is not a CampsiteService instance');
        }
        return $this->campsiteService;
    }
}
