<?php


namespace Cms\Extension\MediaHandler;

/**
 * Class MediaHandlerSizeTrait
 * @package Cms\Extension\MediaHandler
 */
trait MediaHandlerSizeTrait
{

    /** @var  string */
    private $formatName = 'default';

    /** @var  array */
    private $formatSize = [];

    /**
     * @param string $formatName
     */
    public function setDefaultFormat($formatName)
    {
        $this->formatName = $formatName;
    }

    /**
     * @param string $formatName
     * @param int $deskWidth
     * @param int $deskHeight
     * @param int $mobileWidth
     * @param int $mobileHeight
     * @param null|int $tabWidth
     * @param null|int $tabHeight
     * @return $this
     */
    public function setFormatSize(
        $formatName,
        $deskWidth,
        $deskHeight,
        $mobileWidth,
        $mobileHeight,
        $tabWidth = null,
        $tabHeight = null
    ) {
        $this->formatSize[$formatName] = [
            'desktop' => [
                'width' => $deskWidth,
                'height' => $deskHeight,
            ],
            'mobile' => [
                'width' => $mobileWidth,
                'height' => $mobileHeight,
            ],
            'tab' => [
                'width' => $tabWidth,
                'height' => $tabHeight,
            ],
        ];
        return $this;
    }

    /**
     * @param string|null $formatName
     * @return null|array
     */
    public function getFormatSize($formatName = null)
    {
        $formatName = $formatName ?: $this->formatName;
        if (!empty($this->formatSize[$formatName])) {
            return $this->formatSize[$formatName];
        }
        return null;
    }
}
