<?php

namespace Cms\Model\Campsite\Feature;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class FeatureI18nModel
 * @package Cms\Model\Campsite\Feature
 * @property string $code
 * @property string $name
 * @property string $prefix
 * @property string $description
 * @property string $help_desc
 */
class FeatureI18nModel extends DomainObjectAbstract implements I18nModelInterface
{
    use I18nModelTrait;

    /**
     * @relation
     * @var string
     */
    protected $code;

    /** @var string */
    protected $name;

    /** @var string */
    protected $prefix;

    /** @var string */
    protected $description;

    /** @var string */
    protected $help_desc;
}
