<?php

namespace Cms\Model\Geodata;

use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class CityI18nModel
 * @package Cms\Model\Geodata
 * @property int $id
 * @property string $name
 * @property string $name_slug
 * @property string $situation
 * @property string $prefix_le
 * @property string $prefix_a
 * @property string $prefix_de
 * @property string $description
 */
class CityI18nModel extends DomainObjectAbstract implements I18nModelInterface
{
    use I18nModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $name_slug;

    /** @var  string */
    protected $situation;

    /** @var  string */
    protected $prefix_le;

    /** @var  string */
    protected $prefix_a;

    /** @var  string */
    protected $prefix_de;

    /** @var  string */
    protected $description;
}
